-- new script file

function OnAfterSceneLoaded(self)
  CreateTriggerTargets(self)
  CreateTriggerSources(self)
end

function OnThink(self)
  if not self.initialized then
    self.initialized = true
    
    if not self.loaded then
      self.lTCounter = 0
    end
    
    self.lTownHandler:LinkToTarget("lTown")
  	self.lTownHandler:LinkToTarget("lAttackDeact")
    self.lTownHandler:LinkToTarget("lTownReinf")
  end
  
  if self.lTCounter == 3 then
    self.lTownHandler:TriggerAllTargets()
	  self.lTCounter = 0
  end
   
end

function OnTrigger(self, source, target)
  if target == "lTownBuildings" then
    self.lTCounter = self.lTCounter + 1
  end
end

function OnSerialize(self, ar)
  if (ar:IsLoading()) and Citadels.GetLoadGameRunning() then
    CreateTriggerSources(self)
    self.loaded = true
    self.lTCounter = ar:Read()
  elseif (ar:IsSaving()) then
    ar:Write(self.lTCounter)
  end
end

function CreateTriggerTargets(self)
  self:AddTriggerTarget("lTownBuildings")
end

function CreateTriggerSources(self)
  self:AddTriggerSource("lTownHandler")
end
